Puppet::Functions.create_function('enterprise_tasks::with_agent_disabled') do
  dispatch :with_disable do
    param 'Variant[String,Array[String],Target,Array[TargetSpec]]', :nodes
    optional_param 'Optional[Boolean]', :_catch_errors
    block_param 'Callable', :_block
    return_type 'Hash'
  end

  def with_disable(nodes, _catch_errors = false, &_block) # rubocop:disable Lint/UnderscorePrefixedVariableName (_catch_errors is bolt usage)
    disabled_key = 'agent_disabled_by_with_agent_disable_function'
    targets = call_function('get_targets', nodes)
    # If it was already disabled by a plan higher up in the stack, don't disable it again
    targets_to_disable = targets.select { |t| !t.vars[disabled_key] }
    disable_result = call_function('run_task', 'enterprise_tasks::disable_agent', targets_to_disable, '_catch_errors' => _catch_errors)
    # Orch logs errors to the console automatically, but we must call log::error for Bolt to expose the error
    call_function('log::error', disable_result.error_set) unless disable_result.error_set.empty?
    disable_result.ok_set.targets.each { |t| call_function('set_var', t, disabled_key, true) }
    # Collect a list of all targets disabled, whether we did the disabling here or it was already disabled,
    # so that the plan can act on that list.
    disabled_targets = targets.select { |t| t.vars[disabled_key] }
    # if the block has a PlanFailure, we need to re-raise that in the ensure below, after agents restart, so the whole plan fails as expected
    block_exception = nil
    block_result = begin
                     yield(disabled_targets)
                   rescue StandardError => e
                     block_exception = e
                   end
  ensure
    # Even though the disable task might have errored before, try the enable task on those
    # failed nodes anyway to have a glimmer of hope of re-enabling the agent.
    enable_result = call_function('run_task', 'enterprise_tasks::enable_agent', targets_to_disable, '_catch_errors' => _catch_errors)
    enable_result.ok_set.targets.each { |t| call_function('set_var', t, disabled_key, false) }
    call_function('log::error', enable_result.error_set) unless enable_result.error_set.empty?
    raise block_exception unless block_exception.nil?
    return { 'block_result' => block_result, 'disable_result' => disable_result, 'enable_result' => enable_result } # rubocop:disable Lint/EnsureReturn (NOTE: PE-36102 This does need to be fixed, but that patch will need further discussion and testing so I'm temporarily allowing this so we have a clean rubocop slate.)
  end
end
